<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Common;
use App\Models\Group_Battles;
use App\Models\Group_Battles_Leaderboard;
use App\Models\User;
use Illuminate\Http\Request;
use Exception;

class GroupBattlesController extends Controller
{
    private $folder = "user";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index(Request $request)
    {
        try {

            $params['user'] = User::latest()->get();
            if ($request->ajax()) {

                $input_search = $request['input_search'];
                $input_start_date = $request['input_start_date'];
                $input_end_date = $request['input_end_date'];
                $input_c_user_id = $request['input_c_user_id'];
                $input_status = $request['input_status'];

                $query = Group_Battles::latest();
                if ($input_search) {
                    $query->where(function ($q) use ($input_search) {
                        $q->where('room_code', 'LIKE', "%{$input_search}%")->orWhere('name', 'LIKE', "%{$input_search}%");
                    });
                }
                if (!empty($input_start_date)) {
                    $query->whereDate('created_at', '>=', date('Y-m-d', strtotime($input_start_date)));
                }
                if (!empty($input_end_date)) {
                    $query->whereDate('created_at', '<=', date('Y-m-d', strtotime($input_end_date)));
                }
                if ($input_c_user_id != 0) {
                    $query->where('created_user_id', $input_c_user_id);
                }
                if ($input_status != 'all') {
                    $query->where('status', $input_status);
                }
                $data = $query->with('created_user')->latest()->get();

                return DataTables()::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function ($row) {

                        $battles_delete = __('label.delete_battles');

                        $delete = '<form onsubmit="return confirm(\'' . $battles_delete . '\');" method="POST" action="' . route('admin.group_battles.destroy', [$row->id]) . '">
                            <input type="hidden" name="_token" value="' . csrf_token() . '">
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit" class="edit-delete-btn" style="outline: none;"><i class="fa-solid fa-trash-can fa-xl"></i></button></form>';

                        $btn = '<div class="d-flex justify-content-around">';
                        $btn .= '<a href="' . route('admin.group_battles.show', [$row->id]) . '" class="edit-delete-btn mr-2">';
                        $btn .= '<i class="fa-solid fa-eye fa-xl"></i>';
                        $btn .= '</a>';
                        $btn .= $delete;
                        $btn .= '</a></div>';
                        return $btn;
                    })
                    ->addColumn('status', function ($row) {
                        if ($row->status == 0) {
                            $showLabel = __('label.pending');
                            return "<button type='button' class='hide-btn'>$showLabel</button>";
                        } else if ($row->status == 1) {
                            $showLabel = __('label.started');
                            return "<button type='button' class='info-btn'>$showLabel</button>";
                        } else {
                            $hideLabel = __('label.completed');
                            return "<button type='button' class='show-btn px-2'>$hideLabel</button>";
                        }
                    })
                    ->rawColumns(['action', 'status'])
                    ->make(true);
            }
            return view('admin.group_battles.index', $params);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function destroy($id)
    {
        try {

            Group_Battles::where('id', $id)->delete();
            Group_Battles_Leaderboard::where('group_battles_id', $id)->delete();
            return redirect()->route('admin.group_battles.index')->with('success', __('label.battles_delete'));
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function show($id)
    {
        try {

            $params['data'] = Group_Battles::where('id', $id)->with(['created_user'])->first();
            if ($params['data']) {

                if ($params['data']['created_user'] != null) {
                    $params['data']['created_user']['image'] = $this->common->getImage($this->folder, $params['data']['created_user']['image']);
                } else {
                    $params['data']['created_user']['image'] = asset('assets/imgs/default.png');
                }

                $params['leaderboard'] = Group_Battles_Leaderboard::where('group_battles_id', $id)->orderBy('is_winner', 'desc')->with('user')->latest()->get();
                for ($i = 0; $i < count($params['leaderboard']); $i++) {
                    if ($params['leaderboard'][$i]['user'] != null) {
                        $params['leaderboard'][$i]['user']['image'] = $this->common->getImage($this->folder, $params['leaderboard'][$i]['user']['image']);
                    }
                }
                return view('admin.group_battles.show', $params);
            } else {
                return redirect()->back()->with('error', __('label.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
